% SETUP
tStart = tic;
secs_per_minute = 60;
max_swap = 200; %[200 400 800]
diary(sprintf('swaps_%d.log',max_swap));
src_dir = pwd;
csv_dir = [src_dir(1:end-3) 'csv'];
addpath(csv_dir);

% READ IN CONNECTOMES
fprintf(1,'%% Loading connectomes ... ');
A = read_connectome('male_connectome_graph.csv');
B = read_connectome('female_connectome_graph.csv');
fprintf(1,'%3.1f sec.\n',toc(tStart));

% WARM START
fprintf(1,'%% Initializing at submission benchmark.\n');
P = read_solution('vnc_matching_submission_benchmark_5154247.csv');

% SWAP
P = greedy_search(P,A,B,max_swap);

% SAVE SOLUTION
scoreP = full(sum(min(A*P,P*B),'all'));
filename = sprintf('vnc_matching_submission_%07d.csv',scoreP);
save_solution(filename,P);

% DONE
tMin = toc(tStart)/secs_per_minute;
fprintf('%%\n%% Total elapsed time is %.1f minutes.\n',tMin);
rmpath(csv_dir);
diary off;